Attribute VB_Name = "MWt"
Function MWt(InText)
'============================================================================
'FUNCTION:   MWt
'TASK:       Calculation of the Bed Expansion of a fluidised bed
'AUTHOR/REV: AA
'REFERENCE:  Coulson & Richardson, Chemical Engineering Volume 2, 5th Ed. Chapter 6
'
'This Macro Function is provided based on the knowledge of the author at the time of writing.  The author believes that the content is accurate at the time of writing,
'but is unable to provide any warranty that there are no errors or inaccuracies.
'This design guide is provided as an open source knowledge document.  It may be copied, modified and used in any way the user sees fit.
'However, the author expressly denies any liability for the consequences of a user using his document.
'It is the responsibility of the user to verify the accuracy of the information for any use the user might make of it.
'============================================================================

Dim FormulaLength As Integer
Dim Element(10) As String
Dim Stoichiometry(10) As Integer
Dim Mass(10) As Double
Dim CharType(20) As String
Dim IsBracket(10) As Boolean
Dim I, J, El, NoEls, BracketMult, BrackStoich(10) As Integer
Dim MolWt As Double
Dim Hydration As Single

FormulaLength = Len(InText)
  Select Case Asc(Left(InText, 1))
  Case 48 To 57
    NoEls = 1
    Stoichiometry(1) = 1
    Element(1) = InText
    BrackStoich(1) = 1
  Case Else
    'if right(left(intext,i),1)
      For I = 1 To FormulaLength
          Select Case Asc(Right(Left(InText, I), 1))
          Case 40         'Left Bracket
            CharType(I) = "LB"
          Case 41         'Right Bracket
            CharType(I) = "RB"
          Case 46         'Decimal Point
            CharType(I) = "DP"
          Case 48 To 57   'Number
            CharType(I) = "N"
          Case 65 To 90   'Upper Case
            CharType(I) = "U"
          Case 97 To 122  'Lower Case
            CharType(I) = "L"
          Case Else
            Stop
          End Select
      Next I
    
    El = 0
      For I = 1 To FormulaLength
          If CharType(I) = "LB" Then
            IsBracket(El + 1) = True
            I = I + 1
          ElseIf CharType(I) = "RB" Then
            IsBracket(El + 1) = False
              If CharType(I + 1) = "N" Then
                  If CharType(I + 2) = "N" Then
                    BracketMult = Right(Left(InText, I + 2), 2)
                    I = I + 2
                  Else
                    BracketMult = Right(Left(InText, I + 1), 1)
                    I = I + 1
                  End If
                I = I + 1
              End If
          Else
            IsBracket(El + 1) = IsBracket(El)
          End If
          
          If CharType(I) = "DP" Then
              If CharType(I + 1) = "U" Then
                Hydration = 1
              ElseIf CharType(I + 2) = "U" Then
                Hydration = Right(Left(InText, I + 1), 1)
              ElseIf CharType(I + 3) = "U" Then
                Hydration = Right(Left(InText, I + 2), 2)
              ElseIf CharType(I + 4) = "U" Then
                Hydration = Right(Left(InText, I + 3), 3)
              ElseIf CharType(I + 5) = "U" Then
                Hydration = Right(Left(InText, I + 4), 4)
              End If
            I = FormulaLength + 1
          End If
          
          If CharType(I) = "U" Then
            El = El + 1
              If CharType(I + 1) = "L" Then
                  If CharType(I + 2) = "L" Then
                    Element(El) = Right(Left(InText, I + 2), 3)
                    I = I + 2
                  Else
                    Element(El) = Right(Left(InText, I + 1), 2)
                    I = I + 1
                  End If
              Else
                Element(El) = Right(Left(InText, I), 1)
              End If
              If CharType(I + 1) = "N" Then
                  If CharType(I + 2) = "N" Then
                    Stoichiometry(El) = Right(Left(InText, I + 2), 2)
                    I = I + 2
                  Else
                    Stoichiometry(El) = Right(Left(InText, I + 1), 1)
                    I = I + 1
                  End If
              Else
                Stoichiometry(El) = 1
              End If
          End If
      Next I
    NoEls = El
  
      For I = 1 To NoEls
          If IsBracket(I) = True Then
            BrackStoich(I) = BracketMult
          Else
            BrackStoich(I) = 1
          End If
      Next I
  End Select
  
MolWt = 0
  For El = 1 To NoEls
      Select Case Element(El)
      Case "H", 1
        Mass(El) = 1.00794
      Case "He", 2
        Mass(El) = 4.002602
      Case "Li", 3
        Mass(El) = 6.941
      Case "Be", 4
        Mass(El) = 9.012182
      Case "B", 5
        Mass(El) = 10.811
      Case "C", 6
        Mass(El) = 12.0107
      Case "N", 7
        Mass(El) = 14.0067
      Case "O", 8
        Mass(El) = 15.9994
      Case "F", 9
        Mass(El) = 18.998403
      Case "Ne", 10
        Mass(El) = 20.1797
      Case "Na", 11
        Mass(El) = 22.989769
      Case "Mg", 12
        Mass(El) = 24.305
      Case "Al", 13
        Mass(El) = 26.981539
      Case "Si", 14
        Mass(El) = 28.0855
      Case "P", 15
        Mass(El) = 30.973762
      Case "S", 16
        Mass(El) = 32.065
      Case "Cl", 17
        Mass(El) = 35.453
      Case "Ar", 18
        Mass(El) = 39.948
      Case "K", 19
        Mass(El) = 39.0983
      Case "Ca", 20
        Mass(El) = 40.078
      Case "Sc", 21
        Mass(El) = 44.955912
      Case "Ti", 22
        Mass(El) = 47.867
      Case "V", 23
        Mass(El) = 50.9415
      Case "Cr", 24
        Mass(El) = 51.9961
      Case "Mn", 25
        Mass(El) = 54.938045
      Case "Fe", 26
        Mass(El) = 55.845
      Case "Co", 27
        Mass(El) = 58.933195
      Case "Ni", 28
        Mass(El) = 58.6934
      Case "Cu", 29
        Mass(El) = 63.546
      Case "Zn", 30
        Mass(El) = 65.409
      Case "Ga", 31
        Mass(El) = 69.723
      Case "Ge", 32
        Mass(El) = 72.64
      Case "As", 33
        Mass(El) = 74.9216
      Case "Se", 34
        Mass(El) = 78.96
      Case "Br", 35
        Mass(El) = 79.904
      Case "Kr", 36
        Mass(El) = 83.798
      Case "Rb", 37
        Mass(El) = 85.4678
      Case "Sr", 38
        Mass(El) = 87.62
      Case "Y", 39
        Mass(El) = 88.90585
      Case "Zr", 40
        Mass(El) = 91.224
      Case "Nb", 41
        Mass(El) = 92.90638
      Case "Mo", 42
        Mass(El) = 95.94
      Case "Tc", 43
        Mass(El) = 98
      Case "Ru", 44
        Mass(El) = 101.07
      Case "Rh", 45
        Mass(El) = 102.9055
      Case "Po", 46
        Mass(El) = 106.42
      Case "Ag", 47
        Mass(El) = 107.8682
      Case "Cd", 48
        Mass(El) = 112.411
      Case "In", 49
        Mass(El) = 114.818
      Case "Sn", 50
        Mass(El) = 118.71
      Case "Sb", 51
        Mass(El) = 121.76
      Case "Te", 52
        Mass(El) = 127.6
      Case "I", 53
        Mass(El) = 126.90447
      Case "Xe", 54
        Mass(El) = 131.293
      Case "Cs", 55
        Mass(El) = 132.90545
      Case "Ba", 56
        Mass(El) = 137.327
      Case "La", 57
        Mass(El) = 138.90547
      Case "Ce", 58
        Mass(El) = 140.116
      Case "Pr", 59
        Mass(El) = 140.90765
      Case "Nd", 60
        Mass(El) = 144.242
      Case "Pm", 61
        Mass(El) = 145
      Case "Sm", 62
        Mass(El) = 150.36
      Case "Eu", 63
        Mass(El) = 151.964
      Case "Gd", 64
        Mass(El) = 157.25
      Case "Tb", 65
        Mass(El) = 158.92535
      Case "Dy", 66
        Mass(El) = 162.5
      Case "Ho", 67
        Mass(El) = 164.93032
      Case "Er", 68
        Mass(El) = 167.259
      Case "Tm", 69
        Mass(El) = 168.93421
      Case "Yb", 70
        Mass(El) = 173.04
      Case "Lu", 71
        Mass(El) = 174.967
      Case "Hf", 72
        Mass(El) = 178.49
      Case "Ta", 73
        Mass(El) = 180.94788
      Case "W", 74
        Mass(El) = 183.84
      Case "Re", 75
        Mass(El) = 186.207
      Case "Os", 76
        Mass(El) = 190.23
      Case "Ir", 77
        Mass(El) = 192.217
      Case "Pt", 78
        Mass(El) = 195.084
      Case "Au", 79
        Mass(El) = 196.96657
      Case "Hg", 80
        Mass(El) = 200.59
      Case "Tl", 81
        Mass(El) = 204.3833
      Case "Pb", 82
        Mass(El) = 207.2
      Case "Bi", 83
        Mass(El) = 208.9804
      Case "Po", 84
        Mass(El) = 209
      Case "At", 85
        Mass(El) = 210
      Case "Rn", 86
        Mass(El) = 222
      Case "Fr", 87
        Mass(El) = 223
      Case "Ra", 88
        Mass(El) = 226
      Case "Ac", 89
        Mass(El) = 227
      Case "Th", 90
        Mass(El) = 232.03806
      Case "Pa", 91
        Mass(El) = 231.03588
      Case "U", 92
        Mass(El) = 238.02891
      Case "Np", 93
        Mass(El) = 237
      Case "Pu", 94
        Mass(El) = 244
      Case "Am", 95
        Mass(El) = 243
      Case "Cm", 96
        Mass(El) = 247
      Case "Bk", 97
        Mass(El) = 247
      Case "Cf", 98
        Mass(El) = 251
      Case "Es", 99
        Mass(El) = 252
      Case "Fm", 100
        Mass(El) = 257
      Case "Md", 101
        Mass(El) = 258
      Case "No", 102
        Mass(El) = 259
      Case "Lr", 103
        Mass(El) = 262
      Case "Rf", 104
        Mass(El) = 267
      Case "Db", 105
        Mass(El) = 268
      Case "Sg", 106
        Mass(El) = 271
      Case "Bh", 107
        Mass(El) = 272
      Case "Hs", 108
        Mass(El) = 270
      Case "Mt", 109
        Mass(El) = 276
      Case "Ds", 110
        Mass(El) = 281
      Case "Rg", 111
        Mass(El) = 280
      Case "Uub", 112
        Mass(El) = 285
      Case "Uut", 113
        Mass(El) = 284
      Case "Uuq", 114
        Mass(El) = 289
      Case "Uup", 115
        Mass(El) = 288
      Case "Uuh", 116
        Mass(El) = 293
      Case "Uuo", 118
        Mass(El) = 294
      Case "Air"
        Mass(El) = 28.96
        
      Case Else
        
        Stop
      End Select
    MolWt = MolWt + Mass(El) * Stoichiometry(El) * BrackStoich(El)
  Next El

MWt = MolWt + Hydration * (1.00794 * 2 + 15.9994)

End Function
